//Source file: H:\src\Alkindi\Services\Util\ProdRecData.java

package Alkindi.Services.InternalData;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;

/* 
$Header: ProdRecData.java, 9, 4/26/01 2:36:58 PM, Schwartz, Joe$
$Log: 
 9    Alkindi Development1.8         4/26/01 2:36:58 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 8    Alkindi Development1.7         4/26/01 1:46:06 PM   Schwartz, Joe   Moved
      to new package.
 7    Alkindi Development1.6         4/26/01 1:21:48 PM   Schwartz, Joe   Added
      new avgEval attribute & parsing code.
 6    Alkindi Development1.5         3/2/01 4:59:45 PM    Schwartz, Joe  
      Modified to initialize predictedRating to 1.
 5    Alkindi Development1.4         2/27/01 1:00:42 PM   Schwartz, Joe  
      Removed PRDComparator inner class; replaced with implementation of
      Comparable interface. Moved attributes & operations for managing SF for
      comparison to parent class.
 4    Alkindi Development1.3         2/22/01 3:15:03 PM   Schwartz, Joe   Added
      getComparator method to simplify control of comparisons.
 3    Alkindi Development1.2         2/19/01 6:16:15 PM   Schwartz, Joe   Added
      fromResultSet() generator method.
 2    Alkindi Development1.1         2/16/01 5:49:09 PM   Schwartz, Joe   Added
      SQLData implementation. Modified class members to match Oracle UDTs.
 1    Alkindi Development1.0         2/12/01 4:10:26 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Represents statistical and Recommendation Engine-specfic data for a Product. <br>
 * This class provides a static method to parse an instance of the class from a ResultSet.<p>
 * 
 * @see Alkindi.Services.ServicesImpl.RecommendationManager
 */
public class ProdRecData implements Comparable 
{
	
	/**
	 * The Scoring Function ID to use for comparing ProdRecData objects..
	 */
	private static int activeSF = 0;
	
	/**
	 * The overall average evaluation for the product.
	 */
	public float avgEval = 0;
	
	/**
	 * Average product evaluation within a User's UC.
	 */
	public float avgProdEvalInUC = 0;
	
	/**
	 * The User's rating for the product, if any.
	 */
	public int existingEval = 0;
	
	/**
	 * The timestamp of the User's evaluation for the Product, if any.
	 */
	public Date existingEvalTimestamp = null;
	
	/**
	 * The User's Predicted Rating for the Product.
	 */
	public float predRating = 0;
	
	/**
	 * The priority of a product helps govern when it will be recommended.  This quantity is not read from the database; it is assigned externally.
	 */
	public int priority = 100;
	
	/**
	 * The ID of theProduct whose data is represented.
	 */
	public int productID = 0;
	
	/**
	 * The Scoring Function values for the Product within a particular User Cluster.
	 */
	public float[] scores = null;
	
	/**
	 * Compares this ProdRecData object with another using their scores using the current active Scoring Function ID stored in the property activeSF. Higher scores make a ProdRecData appear to be "less than" others, allowing them to be quickly sorted by decreasing score.
	 * @roseuid 3A83540D035B
	 */
	public int compareTo(Object src) 
	{
		ProdRecData prd2 = (ProdRecData)src;

		//	If Product IDs are the same, then the objects are considered equal.
		//
		if (productID == prd2.productID)
			return 0;
				
		//	Compare scores within equal priority.
		//			
		if (priority == prd2.priority) {
			float diff = prd2.scores[activeSF] - scores[activeSF];
			if (diff == 0)
				return 0;
			return (diff > 0) ? 1 : -1;
		}
		else {
			//	Otherwise, lower priority wins.
			//
			return priority - prd2.priority;
		}
	}
	
	/**
	 * Override of <tt>Object.equals</tt>, used by <tt>ArrayList.indexOf</tt>. Uses the productID field to determine equality. This can be used to quickly locate a ProdRecData item.
	 * @roseuid 3A92CBB50157
	 */
	public boolean equals(java.lang.Object src) 
	{
		return (((ProdRecData)src).productID == productID);
	}
	
	/**
	 * Parses the current record into a new instance of ProdRecData.
	 * @roseuid 3A91948D031C
	 */
	public static ProdRecData fromResultSet(java.sql.ResultSet rsIn, final int numSF) throws SQLException 
	{
		ProdRecData prData = new ProdRecData(numSF);
		prData.productID = rsIn.getInt(1);
		prData.avgProdEvalInUC = rsIn .getFloat(2);
		for (int idx = 0; idx < prData.scores.length; idx ++) {
			prData.scores[idx] = rsIn.getFloat(idx + 3);
		}
		prData.existingEval = rsIn.getInt(11);
		prData.existingEvalTimestamp = rsIn.getDate(12);
		prData.predRating = rsIn.getFloat(13);
		prData.avgEval = rsIn.getFloat(14);
		prData.priority = 1;				//	DEFAULT to priority 1.
		
		return prData;
	}
	
	/**
	 * Constructor which accepts the number of Scoring Functions used by the system.
	 * @roseuid 3A8D7924029F
	 */
	public ProdRecData(final int numSF) 
	{
		scores = new float[numSF];
		java.util.Arrays.fill(scores, 0);
	}
	
	/**
	 * Assigns a new active Scoring Function ID to use as a basis for comparisons.
	 * @roseuid 3A8D7DA30128
	 */
	public static final void useSF(int sfToUse) 
	{
			activeSF = sfToUse;
	}
}
